﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Http;

namespace DeX_Demo_Jun21
{
    public class CommsLoad : BaseCall
    {
        #region Contracts with the outside world
        // Main entities
        
        #region Class Definitions for the outside world
        #endregion
     
        #region Collections of data available to the outside world
        #endregion
        #region functions available to the outsider world
        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="_callInfo"></param>
        public CommsLoad(PostitCommon.CallInfo _callInfo)
        {
            callInfo = _callInfo;
        }
        /// <summary>
        /// Loads all of the data to make it available externally
        /// </summary>
        public void Load()
        {
            LoadInternal();
        }
        #endregion
        #endregion

        public static HttpClient httpClient = new HttpClient();
        #region Bits to support DeX OData
        /// <summary>
        /// Base URL for DeX
        /// </summary>
        public const string URLBase = "https://seli00apm01.azure-api.net/dex//";
        /// <summary>
        /// A simple device to format the URL and cope with version changes
        /// </summary>
        /// <param name="Service"></param>
        /// <param name="Call"></param>
        /// <returns></returns>
        private static string SetURL(string Service, string Call)
        {
           // <Base>\staff/odata/v3/StaffPersonalBasics
           return URLBase + string.Format("{0}/odata/V3/{1}", Service, Call);
        }
        /// <summary>
        /// This function is included to get around an initial bug 
        /// however, once fixed the 'bad' url won't occur and 
        /// </summary>
        /// <param name="nextLink"></param>
        /// <returns></returns>
        public static string GetNextLink(string nextLink)
        {
            string bad = "https://sims8live01.westeurope.cloudapp.azure.com:8443";
            if (nextLink.StartsWith(bad))
            {
                string[] bits = nextLink.Split('/');
                string service = bits[3].Substring(0, bits[3].IndexOf("servicefarm1"));
                string call = bits[6];

                //https://sims8live01.westeurope.cloudapp.azure.com:8443/learnerservicefarm1/odata/v3/LearnerPersonals?$select=ExternalID%2CDateOfBirth&$skip=1000
                // https://seli00apm01.azure-api.net/dex/Learner/odata/V3/LearnerPersonals?$select=ExternalID,DateOfBirth
                // https://seli00apm01.azure-api.net/dex/learnerservicefarm1/odata/v3/LearnerPersonals?$select=ExternalID%2CDateOfBirth&$skip=1000
                // https://seli00apm01.azure-api.net/dex/learnerservicefarm1/odata/v3/LearnerPersonals?$select=ExternalID%2CDateOfBirth&$skip=1000
                string s = SetURL(service, call);
                return s;
            }
            return nextLink;
        }
        #endregion
        #region Contact Basics - we need this to fill in some info about a contact
        private void LoadContactBasics()
        {
            #region sample call
            /*
              {
            "ExternalID": "1f336494-04e6-47bc-9026-e2f065816325",
            "Forename": "Filomena",
            "Surname": "Zanni",
            "MiddleName": null,
            "IsTranslatorRequired": false,
            "ParentalBallot": false,
            "Honours": null,
            "Salutation": "Mrs Zanni",
            "Addressee": "Mrs F Zanni",
            "PlaceOfWork": null,
            "JobTitle": null,
            "Title": {
                "ExternalID": "f5a9c166-55d4-4dce-b7d2-9ec60bd5e4e4",
                "Type": "Learner.Lookup.Title"
            },
            "HomeLanguage": {
                "ExternalID": "94407bc6-1294-4e04-9432-e0bb2e6ea0ba",
                "Type": "Learner.Lookup.Language"
            },
            "Gender": {
                "ExternalID": "e471b9a3-088b-4f96-a155-60f9fad732ae",
                "Type": "Learner.Lookup.Gender"
            },
            "Occupation": {
                "ExternalID": "91580e00-bc85-41ae-9581-2cecf389a2ea",
                "Type": "Learner.Lookup.Occupation"
            }
        },

   
             */
            #endregion
            string URL_ContactDetails = SetURL("Learner", "ContactBasics");
            string resp = DoCall(URL_ContactDetails, callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
            ODataResponse<ContactBasics_Response> contacts = null;
            try
            {
                contacts = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<ContactBasics_Response>>(resp);
                foreach (ContactBasics_Response s in contacts.Value)
                {
                    ContactBasics_Values.Add(s.ExternalID, s);
                }
                // Very likely > 1000
                while (!string.IsNullOrEmpty(contacts.NextLink))
                {
                    resp = DoCall(GetNextLink(contacts.NextLink), callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
                    contacts = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<ContactBasics_Response>>(resp);
                    foreach (ContactBasics_Response s in contacts.Value)
                    {
                        ContactBasics_Values.Add(s.ExternalID, s);
                    }
                }
            }
            catch
            {
                ErrorMessage = "Error: " + resp;
            }

        }
        #endregion
       
        #region NC Year Groups
        public class PastoralGroup_Response
        {
            public Guid ExternalID;
            public string ShortName;
        }
        public class NCY_Member
        {
            public Guid ExternalID;
            public Guid Learner;

        }
        private Dictionary<Guid, PastoralGroup_Response> NCYears = new Dictionary<Guid, PastoralGroup_Response>();
        private void Load_PastoralGroups()
        {
            string URL_PGS = SetURL("PastoralGroups", "PastoralGroupDefinitions?$filter=PastoralGroupType eq 'SchoolNCYear'&$select=ExternalID,ShortName&");
            string resp = DoCall(URL_PGS, callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
            ODataResponse<PastoralGroup_Response> pg_response = null;
            try
            {
                pg_response = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<PastoralGroup_Response>>(resp);
                foreach (PastoralGroup_Response s in pg_response.Value)
                {
                    NCYears.Add(s.ExternalID, s);
                }
            }
            catch
            {

            }
        }
        
        #region Lookups

        public static Dictionary<Guid, BaseLookup> Titles = new Dictionary<Guid, BaseLookup>();
        public static Dictionary<Guid, BaseLookup> Genders = new Dictionary<Guid, BaseLookup>();
        public class BaseLookup
        {
            public Guid ExternalID;
            public string Type;
            public string Description;
            // Get the values for lookups;
            public static void GetValues(ref Dictionary<Guid, BaseLookup> values, string URL)
            {
                values.Clear();
                string resp = DoCall(URL, callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
                ODataResponse<BaseLookup> lookups = null;
                try
                {
                    lookups = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<BaseLookup>>(resp);
                    foreach (BaseLookup s in lookups.Value)
                    {
                        values.Add(s.ExternalID, s);
                    }
                    // Very unlikely  > 1000
                    while (!string.IsNullOrEmpty(lookups.NextLink))
                    {
                        resp = DoCall(GetNextLink(lookups.NextLink), callInfo.bearerToken.Token, httpClient, callInfo.arq.OCP_APIM_Key);
                        lookups = Newtonsoft.Json.JsonConvert.DeserializeObject<ODataResponse<BaseLookup>>(resp);
                        foreach (BaseLookup s in lookups.Value)
                        {
                            values.Add(s.ExternalID, s);
                        }
                    }
                }
                catch (Exception ex)
                {
                    ErrorMessage = "Error: " + resp;
                }

            }
        }
        #endregion
       
        #region Common
        public class Lookup
        {
            public Guid ExternalID;
            public string Description;
        }
        public class DateRange
        {
            public Guid ExternalID;
            public Nullable<DateTime> StartDate;
            public Nullable<DateTime> EndDate;

        }

        #endregion
        public static string ErrorMessage = "";
        public static PostitCommon.CallInfo callInfo = null;
        
        private void LoadInternal()
        {
            #region Load
            // Load lookups
            LoadLookups();
            // Want LearnerPersonals to get DOB
            LoadLPs();
            // Want Learner Indentifiers
            LoadLIs();
            // Load Learner Dietarys
            LoadLDs();
            // Load Learner Reg
            LoadLRs();
            // Load Contacts Details
            LoadContactContactDetails();
            // Load Contact Basics
            #endregion

        }
        private static string GetLookupUrl(string table)
        {
            string URL = "LearnerLookups?$filter=LookupType eq '{0}'&$select=ExternalID,LookupType,Description";
            return string.Format(URL, table);

    }
        public static void Run(ref Dictionary<string, XStudent> Collection, PostitCommon.CallInfo _callInfo)
        {
            
            callInfo = _callInfo;
            #region Load
            // Load lookups
            LoadLookups();
             // Want LearnerPersonals to get DOB
            LoadLPs();
            // Want Learner Indentifiers
            LoadLIs();
            // Load Learner Dietarys
            LoadLDs();
            // Load Learner Reg
            LoadLRs();
            // Load Contacts Details
            LoadContactContactDetails();
            // Load Contact Basics
            #endregion
            Collection.Clear();
            Dictionary<Guid, XStudent> students = new Dictionary<Guid, XStudent>();
            LoadS(ref students);
            // OK this is 2 copies of students but when we process parents, we will need to duplicate the student info
            JoinItAllUp(ref Collection, ref students);
        }
        public static void JoinItAllUp(ref Dictionary<string, XStudent> Collection, ref Dictionary<Guid, XStudent> students)
        {
            foreach (ContactDetails_Response c in ContactContactDetails_Values.Values)
            {
                XStudent xs = null;
                string key = "";
                Address xa = null;
                string xEmail = "";
                string xPhone = "";
                if (c.LearnerRelationships != null)
                {
                    // Process the addresses and get one
                    if (c.Addresses != null)
                    {
                        foreach (AddressRecords a in c.Addresses)
                        {
                            if (a.StartDate != null &&
                                a.StartDate <= DateTime.Today &&
                                (a.EndDate == null ||
                                a.EndDate >= DateTime.Today)
                                )
                            {
                                xa = a.Address;
                                break;
                            }

                        }
                    }
                    // Now need a contact email
                    if (c.Emails != null)
                    {
                        foreach (Email em in c.Emails)
                        {
                            if (em.UseForAutomatedMessages == true)
                            {
                                xEmail = em.EmailAddress;
                                break;
                            }
                        }
                    }
                    // Now need a contact phone number
                    if (c.Telephones != null)
                    {
                        foreach (Telephone t in c.Telephones)
                        {
                            if (t.UseForAutomatedMessages == true)
                            {
                                xPhone = t.TelephoneNumber;
                                break;
                            }
                        }
                    }
                    foreach (LearnerRelationships lr in c.LearnerRelationships)
                    {
                        // Guid of parent | Student
                        key = c.ExternalID.ToString() + "|" + lr.Learner.ExternalID.ToString();
                        if (students.TryGetValue(lr.Learner.ExternalID, out xs))
                        {
                            xs.Salutation = c.Salutation;
                            if (xa != null)
                            {
                                xs.AdministrativeArea = xa.AdministrativeArea;
                                xs.Apartment = xa.Apartment;
                                xs.BuildingName = xa.BuildingName;
                                xs.District = xa.District;
                                xs.Postcode = xa.Postcode;
                                xs.Street = xa.Street;
                                xs.Town = xa.Town;
                                xs.BuildingNumber = xa.BuildingNumber;
                            }
                            xs.ContactEmail = xEmail;
                            xs.ContactMobile = xPhone;
                        }
                        if (key != "" && xs != null)
                        {
                            Collection.Add(key, xs);
                        }
                    }
                }

            }

        }

        public static void LoadS(ref Dictionary<Guid, XStudent> students)
        {
            foreach (LI_Response l in LI_Values.Values)
            {
                XStudent s = new XStudent();
                // Build from Identifiers - these are filtered to current.
                {
                    s.ExternalID = l.ExternalID;
                    s.Gender = l.GenderCategory;
                    s.Surname = l.Surname;
                    s.ChosenName = l.Forename;
                    s.CurrentPrimaryClass = "";
                    s.CurrentYearGroup = "";
                    if (l.CurrentPrimaryClass != null)
                    {
                        s.CurrentPrimaryClass = l.CurrentPrimaryClass.Description;
                    }
                    if (l.CurrentYearGroup != null)
                    {
                        s.CurrentYearGroup = l.CurrentYearGroup.Description;
                    }
                }
                // Add In DOB from Learner Personal
                {
                    Nullable<DateTime> lp = null;
                    if (LP_Values.TryGetValue(s.ExternalID, out lp))
                    {
                        s.DateOfBirth = lp;
                    }
                }
                // Add in Dietaries
                {
                    LD_Response lc = null;
                    if (LD_Values.TryGetValue(s.ExternalID, out lc))
                    {
                        s.free_meal_start = null;
                        s.free_meal_end = null;

                        foreach (DateRange d in lc.FreeMealEligibilityPeriods)
                        {
                            // Take the latest
                            if (s.free_meal_start == null || s.free_meal_start < d.StartDate)
                            {
                                s.free_meal_start = d.StartDate;
                                s.free_meal_end = d.EndDate;
                            }
                        }
                        s.Diet = "";
                        foreach (Lookup lu in lc.DietaryNeeds)
                        {
                            if (s.Diet != "")
                            {
                                s.Diet += ",";
                            }
                            if (lu != null && lu.Description != null)
                                s.Diet += (lu.Description.Replace("\"", "'").Replace(",", ";"));
                        }
                    }

                }
                // Add in Registraions
                {
                    LR_Response lc = null;
                    if (LR_Values.TryGetValue(s.ExternalID, out lc))
                    {
                        s.UPN = lc.UniquePupilNumber;
                        s.AdmissionNumber = lc.AdmissionNumber;
                    }

                }
                students.Add(s.ExternalID, s);
            }
        }
    }
}
